<?php
// messages.php
header('Content-Type: application/json; charset=utf-8');

// Debug bei Bedarf kurz aktivieren:
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

$file = __DIR__ . '/messages.json';

// Wenn Datei noch nicht existiert: leere Liste anlegen
if (!file_exists($file)) {
    file_put_contents($file, '[]');
}

function read_messages($file) {
    $json = @file_get_contents($file);
    if ($json === false || $json === '') {
        return [];
    }
    $data = json_decode($json, true);
    if (!is_array($data)) {
        return [];
    }
    return $data;
}

function write_messages($file, $messages) {
    $json = json_encode($messages, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    if (@file_put_contents($file, $json, LOCK_EX) === false) {
        http_response_code(500);
        echo json_encode([
            'error' => 'Konnte messages.json nicht schreiben. Prüfe Dateirechte!'
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }
}

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';

// GET: alle Mitteilungen
if ($method === 'GET') {
    $messages = read_messages($file);
    echo json_encode($messages, JSON_UNESCAPED_UNICODE);
    exit;
}

// POST: gesamte Liste speichern
if ($method === 'POST') {
    $raw = file_get_contents('php://input');
    $input = json_decode($raw, true);

    if (!is_array($input)) {
        http_response_code(400);
        echo json_encode(['error' => 'Ungültige Daten (erwarte Liste).'], JSON_UNESCAPED_UNICODE);
        exit;
    }

    write_messages($file, $input);
    echo json_encode($input, JSON_UNESCAPED_UNICODE);
    exit;
}

// DELETE: alle Mitteilungen löschen
if ($method === 'DELETE') {
    write_messages($file, []);
    echo json_encode([]);
    exit;
}

// alles andere: nicht erlaubt
http_response_code(405);
echo json_encode(['error' => 'Methode nicht erlaubt.'], JSON_UNESCAPED_UNICODE);
